// import typescript from "rollup-plugin-typescript2";
// import resolve from 'rollup-plugin-node-resolve';
// import commonjs from 'rollup-plugin-commonjs';
import typescript from "rollup-plugin-typescript";
import {terser} from 'rollup-plugin-terser';
import dts from "rollup-plugin-dts";
import path from "path";
const pkg = require('../package.json')
const resolveFile = (...args) => path.resolve(...args);
let inputFile=resolveFile("./src/index.ts")
let libName = "generalTools"
export default [
	{
		// 生成 .d.ts 类型声明文件
		input: inputFile,
		output: {
			file: resolveFile(pkg.types),
			format: 'es',
		},
		plugins: [dts()],
	},
	{
		input: inputFile,
		output: [
			{
				file: resolveFile(pkg.main),
				format: "cjs",
				exports:"default"
			},
			{
				file:resolveFile(pkg.module),
				format: "es",
			},
			{
				file:resolveFile(pkg.browser),
				format: "umd",
				name: libName,
			},
		],
		plugins: [
			typescript({
				exclude: "node_modules/**",
				typescript: require("typescript"),
			}),
			terser()
		],
	}
];

