declare class CountDownInfo {
    time: number;
    day: number;
    hour: number;
    minute: number;
    second: number;
    constructor(time: number);
    format(value: number): string;
}
declare type CountDownFinishCallback = () => void;
declare type CountDownCallback = (info: CountDownInfo) => void;
declare class CountDownTimer {
    private millisInFuture;
    private readonly mInterval;
    private onCountDownFinishListener;
    private onCountDownListener;
    private timeOutId;
    /**
     * @param millisInFuture 时间毫秒数
     * @param countDownInterval 时间毫秒数（单位间隔）
     */
    constructor(millisInFuture: number, countDownInterval: number);
    addCountDownListener(listener: CountDownCallback): void;
    addFinishListener(listener: CountDownFinishCallback): void;
    start(): void;
    cancel(): void;
    static getTimeInfo(time: number): CountDownInfo;
}

declare class DayData {
    year: number;
    month: number;
    day: number;
    isSupplementDay: boolean;
    titleName: string;
    formatDay: string;
    time: number;
    constructor(year: number, month: number, day: number);
    equals(object: DayData): boolean;
    toString(): string;
}

declare class MonthData {
    titleName: string;
    year: number;
    month: number;
    dayItems: Array<DayData>;
    constructor(year: number, month: number);
    toString(): string;
}

declare class CalendarData {
    monthCount: number;
    startYear: number;
    startMonth: number;
    monthDataList: Array<MonthData>;
    /**
     * @param monthCount 月份个数
     * @param startYear 起始年
     * @param startMonth 起始月
     */
    constructor(monthCount: number, startYear?: number, startMonth?: number);
    /**
     * 获取当前时间 （2018-08-15）
     */
    static getCurrentFormatDateString(): string;
    /**
     * 获取日历数据
     * @param year
     * @param month
     */
    static getCalendarMonth(year: number, month: number): MonthData;
    /**
     * 获取上个月的数据
     * @param year
     * @param month
     */
    static getLastMonthData(year: number, month: number): MonthData;
    /**
     * 获取下个月的数据
     * @param year
     * @param month
     */
    static getNextMonth(year: number, month: number): MonthData;
    /**
     * 获取当前月份的日历数据
     */
    static getCurrentMonth(): MonthData;
    /**
     * 获取日历基础数据(从当前月，往后推)
     * @param count
     * @returns {Array}
     */
    static getCalendarMonthList(count: number): Array<MonthData>;
}

declare class LogUtils {
    private readonly enableDebug;
    constructor(debug: any);
    getTag(tag: string): string;
    debug(msg: any): void;
    debugWithTag(tag: string, msg: any): void;
    info(msg: any): void;
    infoWithTag(tag: string, msg: any): void;
    log(msg: any): void;
    logWithTag(tag: string, msg: any): void;
    error(msg: any): void;
    errorWithTag(tag: string, msg: any): void;
    warn(msg: any): void;
    warnWithTag(tag: string, msg: any): void;
}

/**
 * 判断身份证是否合法
 * @param cardNo
 */
declare function isIdCard(cardNo: string): boolean;

declare class StringHelper {
    /**
     * 替换所有
     * @param content 当前文本
     * @param pattern 旧字符串或者正则表达式
     * @param newStr 要替换的内容
     * @returns {*}  返回新的字符串
     */
    static replaceAll(content: string, pattern: string, newStr: string): string;
    static isEmpty(str: string): boolean;
    /**
     * 是否是组织机构代码
     * @param code
     * @returns {*|boolean}
     */
    static isOrganizationCode(code: string): boolean;
    /**
     * 18位的统一信用代码
     * @param code
     * @returns {*|boolean}
     */
    static isUnifiedCreditCode(code: string): boolean;
    /**
     * 校验手机号（严格校验）
     * //移动号段：134 135 136 137 138 139 147 148 150 151 152 157 158 159  165 172 178 182 183 184 187 188 195 198
     * // 联通号段：130 131 132 145 146 155 156 166 167 171 175 176 185 186
     * // 电信号段：133 149 153 173 174 177 180 181 189  191  199
     * // 虚拟运营商:170
     * 分组如下
     * //130 131 132 133 134 135 136 137 138 139
     * //145 146 147 148 149
     * //150 151 152 153 155 156 157 158 159
     * // 165 166 167
     * //170  171  172 173 174  175 176 177 178
     * //180 181 182 183 184 185 186 187 188 189
     * // 191  195  198 199
     * @param phone
     * @returns {boolean}
     */
    static isPhoneNumber(phone: number | string): boolean;
    /**
     * 判断是否是邮件地址
     * @param email
     * @returns {boolean}
     */
    static isEmail(email: string): boolean;
    /**
     * 获取文本（过滤副文本标签）
     * @param richText
     */
    static filterRichText(richText: string): string;
    /**
     * 从富文本中，查找img 标签，收集图片地址(只支持.png .jpg .jpeg 结尾)
     * @param text 富文本
     * @returns {[]}  返回图片列表
     */
    static getImageListFromRichText(text: string): Array<string>;
    static colorRbgToHex(rgbColor: string): string;
    /**
     *16进制颜色转为RGB格式
     * @param hexColor  16进制颜色
     * @returns {string}  RGB格式颜色
     */
    static colorHexToRgb(hexColor: string): string;
    /**
     * 将整数部分逢三一断
     * @param value
     * @returns {string}
     */
    static formatNumber(value: String | number): string;
    /**
     * 通用脱敏
     *
     * 中文名字：只展示姓名第一个字
     * 手机号：前三后四不脱敏，中间脱敏
     * 身份证号：前6后4不脱敏，年月日脱敏
     * 银行卡：前6位和后4位不脱敏，中间脱敏
     * 其他 前6位和后4位不脱敏
     * @param codeStr
     * @return {string}
     */
    static desensitize(codeStr: any): string;
    /**
     * 生成唯一的uuid;
     */
    static generateUUID(): string;
}

declare class ArrayHelper {
    static makeUpGroupList(list: Array<any>, groupNumber: number): Array<any>;
    /**
     * 将数据分组
     * @param value 数据源
     * @param groupNumber 分组的个数
     * @returns {[]|*} 返回分组后的列表
     */
    static grouping(value: Array<any> | string, groupNumber: number): Array<Array<any>>;
}

declare type WatchFun = (newVal: any, oldVal: any) => void;
declare class ObjectHelper {
    /**
     * 克隆函数
     * @param func
     */
    static cloneFunction(func: Function): any;
    /**
     * 深度克隆对象
     * @param obj
     * @param cache
     */
    static cloneDeep(obj: object | Array<any>, cache?: WeakMap<object, object>): any;
    /**
     * 将某个对象追加到当前对象中(扩展对象，类似java中的继承)
     * @param targetObject
     * @param sourceObject
     */
    static extendObject(targetObject: object, sourceObject: object): object;
    /**
     * 判断列表是是否包含特定的对象
     * @param list
     * @param object
     */
    static containObject(list: Array<any>, object: any): boolean;
    /**
     * 深入比较对象(判断对象是否相等)
     * @param object_1
     * @param object_2
     */
    static equalDeep(object_1: any, object_2: any): boolean;
    /**
     *
     * @param keysList 取值字段列表 ["a","b"]
     * @param valuesObject 目标对象｛a:"a",b:"11",c:"aaaa",d:"dd"}
     * @return  {} //如｛a:"a",b:"11"}
     */
    static getObjectByList(keysList: Array<string>, valuesObject: object): object;
    /**
     * 根据当前对象的key,从目标对象中取值
     * @param keysObject {a:""}
     * @param targetObject 目标对象｛a:"a",b:"11",c:"aaaa",d:"dd"}
     * @return  {} //如｛a:"a"}
     */
    static getObjectByObject(keysObject: object, targetObject: object): object;
    /**
     * 从对象中获取值 （支持 "a.b.c" 获取值）
     * @param obj
     * @param keyWords
     */
    static getValueFromObject(obj: object, keyWords: any): any;
    /**
     * 设置监听器
     */
    static addWatcher(data: object, watch: Record<string, (...args: any[]) => any>): void;
    /**
     * 监听属性 并执行监听函数
     */
    static observe(obj: object, key: string, watchFun: WatchFun): void;
}

declare class UrlHelper {
    /**
     * 从地址中截取参数
     * @param url
     * @returns {Map<any, any>}
     */
    static getQueryMapFromUrl(url: string): Map<string, any>;
    /**
     * 获取跳转目标路径
     * @param baseUrl
     * @param params
     * @returns {*}
     */
    static getQueryUrl(baseUrl: string, params: object): string;
}

declare type DateType = string | number | Date;
declare type MonthDayNumber = 29 | 28 | 31 | 30;

declare class DateHelper {
    /**
     * 获取日期实例
     * 兼容ios new Date('2020-10-10') 返回Invalid Date
     * @param date
     */
    static getDateInstance(date: DateType): Date;
    /**
     * 获取某年某月第一天是星期几
     * @param year
     * @param month
     */
    static getWeekDay(year: number, month: number): number;
    /**
     * 格式化数字符串
     * @param num
     */
    static formatNumber(num: number): string;
    static isToday(date: DateType): boolean;
    static getFormatDate(date: DateType): string;
    static getCurrentFormatDate(): string;
    /**
     * 获取当前日期所在月份的天数
     * @param date
     */
    static getDaysInMonth(date: DateType): MonthDayNumber;
    /**
     * 获取星期名称
     * @param date 日期
     * @param isEnglish true 表示是英文
     */
    static getWeekName(date: DateType, isEnglish?: boolean): string;
    /**
     * 是否是闰年
     * @param year
     */
    static isLeapYear(year: number): boolean;
    /**
     * 获取指定月份天数
     * @param year
     * @param month
     * @returns {number}
     */
    static getMonthDays(year: number, month: number): MonthDayNumber;
    /**
     *获取下个月信息
     * @param year
     * @param month
     */
    static getNextMonthInfo(year: number, month: number): {
        year: number;
        month: number;
    };
    /**
     * 获取上个月信息
     * @param year
     * @param month
     */
    static getLastMonthInfo(year: number, month: number): {
        year: number;
        month: number;
    };
    static diffTime(startTime: number, endTime: number, unitTime: number): number;
    /**
     *相差年份数
     * @param startTime
     * @param endTime
     */
    static diffYears(startTime: number, endTime: number): number;
    /**
     * 相差月分数
     * @param startTime
     * @param endTime
     */
    static diffMonths(startTime: number, endTime: number): number;
    /**
     * 相差天数
     * @param startTime
     * @param endTime
     */
    static diffDays(startTime: number, endTime: number): number;
    /**
     * 相差小时数
     * @param startTime
     * @param endTime
     */
    static diffHours(startTime: number, endTime: number): number;
    /**
     * 相差分数
     * @param startTime
     * @param endTime
     */
    static diffMinutes(startTime: number, endTime: number): number;
    /**
     * 相差月秒数
     * @param startTime
     * @param endTime
     */
    static diffSeconds(startTime: number, endTime: number): number;
    /**
     * 格式化时间
     * @param date
     * @param formatStyle
     */
    static formatDateString(date: DateType, formatStyle: string): string;
}

interface ResponseInterceptor {
    success: boolean;
    data: any;
}

/**
 * 拦截器配置信息
 */
interface InterceptorsConfig {
    /**
     * 接口请求拦截器
     * @param header
     */
    onRequestInterceptor?: (header: object) => object;
    /**
     * 接口响应拦截器
     * @param response
     */
    onResponseInterceptor?: (response: any) => ResponseInterceptor;
    /**
     * 获取缓存数据
     * @param baseUrl
     * @param url
     * @param params
     */
    getCacheData?: (baseUrl: string, url: string, params?: any) => any;
    /**
     * 更新响应数据缓存
     * @param data
     * @param baseUrl
     * @param url
     * @param params
     */
    updateResponseCache?: (data: any, baseUrl: string, url: string, params?: any) => void;
    /**
     * 获取缓存的Key
     * @param baseUrl
     * @param url
     * @param data
     * @param params
     */
    getCacheKey?: (baseUrl: string, url: string, data: any, params?: any) => string;
}

declare class HttpClient {
    private readonly baseUrl;
    private readonly platform;
    private readonly requestInterceptorsConfig;
    private readonly taskMap;
    private readonly isMiniApp;
    constructor(platform: object, isMiniApp: boolean, baseUrl: string, requestInterceptorsConfig: InterceptorsConfig);
    post<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    get<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    put<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    delete<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    head<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    options<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    connect<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    trace<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    patch<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    link<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    unlink<T>(path: string, params?: any, headers?: any, cancelToken?: string): Promise<T>;
    private static getTargetUrl;
    private request;
    private getRequestUrl;
    private miniAppRequest;
    private successHandler;
    private getResponseData;
    private commonRequest;
}

declare type ClientInterceptors = () => InterceptorsConfig;
declare class HttpRequest {
    /**
     * 获取求实例
     * @param platform 平台
     * @param isMiniApp 是不是小程序
     * @param baseUrl 地址
     * @param interceptors 拦截器信息
     */
    static getHttpClient(platform: any, isMiniApp: boolean, baseUrl: string, interceptors?: ClientInterceptors): HttpClient;
}

declare const _default: {
    DateConstants: {
        dayMillis: number;
        hourMillis: number;
        minuteMillis: number;
        secondMillis: number;
    };
    CountDownTimer: typeof CountDownTimer;
    CalendarData: typeof CalendarData;
    LogUtils: typeof LogUtils;
    isIdCard: typeof isIdCard;
    StringHelper: typeof StringHelper;
    ObjectHelper: typeof ObjectHelper;
    DateHelper: typeof DateHelper;
    ArrayHelper: typeof ArrayHelper;
    UrlHelper: typeof UrlHelper;
    HttpRequest: typeof HttpRequest;
    HttpClient: typeof HttpClient;
};

export { ArrayHelper, CalendarData, CountDownTimer, DateHelper, DayData, InterceptorsConfig, LogUtils, MonthData, ObjectHelper, ResponseInterceptor, StringHelper, UrlHelper, _default as default, isIdCard };
