import {DateHelper} from '../helper/DateHelper'

export class DayData {
	year: number;
	month: number;
	day: number;
	isSupplementDay: boolean;
	titleName: string;
	formatDay: string;
	time: number;

	constructor(year: number, month: number, day: number) {
		this.year = year;
		this.month = month;
		this.day = day;
		this.isSupplementDay = false;
		this.titleName = String(day);
		this.formatDay = `${year}-${DateHelper.formatNumber(month)}-${DateHelper.formatNumber(day)}`;
		const date = new Date(this.formatDay);
		date.setHours(0, 0, 0, 0)
		this.time = date.getTime();
	}

	equals(object: DayData) {
		return this.year === object.year && this.month === object.month && this.day === object.day
	}

	toString() {
		return "year= " + this.year + "  year= " + this.year + "  year= " + this.year;
	}
}
