import {DayData} from "./DayData";
import {DateHelper} from "../helper/DateHelper";

export class MonthData {
	titleName: string;
	year: number;
	month: number;
	dayItems: Array<DayData>;

	constructor(year: number, month: number) {
		this.titleName = String(month);
		this.year = year;
		this.month = month;
		const days = DateHelper.getMonthDays(year, month);
		this.dayItems = [];
		for (let i = 1; i <= days; i++) {
			const dayInfo = new DayData(this.year, this.month, i);
			this.dayItems.push(dayInfo);
		}
	}

	toString(): string {
		return "year= " + this.year + "  month= " + this.month;
	}
}
