export class ArrayHelper {
	static makeUpGroupList(list: Array<any>, groupNumber: number): Array<any> {
		if (list && list.length > 0) {
			const newList = [...list]
			if (groupNumber < 2) {
				return newList;
			}
			let endCount = newList.length % groupNumber;
			if (endCount > 0) {//补全数据
				for (let i = 0, len = groupNumber - endCount; i < len; i++) {
					newList.push({})
				}
			}
			return newList;
		}
		return list;
	}

	/**
	 * 将数据分组
	 * @param value 数据源
	 * @param groupNumber 分组的个数
	 * @returns {[]|*} 返回分组后的列表
	 */
	static grouping(value: Array<any> | string, groupNumber: number): Array<Array<any>> {
		if (value && groupNumber > 0) {
			const groupList = [];
			let endLength = value.length;
			let startIndex = 0;
			let endIndex = groupNumber;
			while (startIndex < endLength) {
				groupList.push(value.slice(startIndex, endIndex))
				startIndex = startIndex + groupNumber
				endIndex = endIndex + groupNumber
			}
			return groupList;
		}
		return [];
	}


}
