
let area = {
  11: "北京", 12: "天津", 13: "河北", 14: "山西", 15: "内蒙古",
  21: "辽宁", 22: "吉林", 23: "黑龙江", 31: "上海", 32: "江苏",
  33: "浙江", 34: "安徽", 35: "福建", 36: "江西", 37: "山东", 41: "河南",
  42: "湖北", 43: "湖南", 44: "广东", 45: "广西", 46: "海南", 50: "重庆",
  51: "四川", 52: "贵州", 53: "云南", 54: "西藏", 61: "陕西", 62: "甘肃",
  63: "青海", 64: "宁夏", 65: "新疆", 71: "台湾", 81: "香港", 82: "澳门", 91: "国外"
};

let weights = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];//权重
let checkCodes = ['1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'];//校验码
/**
 * 将15转为18位身份证
 * @param cardNo
 */
function changeToEighteen(cardNo: string): string {
  if (cardNo && cardNo.length === 15) {
    //插入年月
    let cardNo17 = cardNo.substring(0, 6) + '19' + cardNo.substring(6);
    //计算组后一位
    let sum = 0;
    for (let i = 0; i < 17; i++) {
      sum += Number.parseInt(cardNo17[i]) * weights[i];
    }
    return cardNo17 + checkCodes[sum % 11];
  }
}


/**
 * 判断身份证是否合法
 * @param cardNo
 */
export function isIdCard(cardNo: string): boolean {
  let regExp = new RegExp("(^\\d{15}$)|(^\\d{17}(\\d|X|x)$)");
  // if (!/(^\d{15}$)|(^\d{17}(\d|X|x)$)/.test(cardNo)) {
  if (!regExp.test(cardNo)) {
    console.log('身份证长度或格式错误')
    return false
  }
  let checkCode = String(cardNo);
  if (checkCode.length === 15) {
    checkCode = changeToEighteen(checkCode);
  }
  if (!area[checkCode.substring(0,2)]) {
    console.log('身份证地区非法')
    return false;
  }
  let birthday = (checkCode.substring(6, 10) + "-" + Number(checkCode.substring(10, 12)) + "-" + Number(checkCode.substring(12, 14))).replace(/-/g, "/");
  let birthDate = new Date(birthday)
  if (birthday != (birthDate.getFullYear() + "/" + (birthDate.getMonth() + 1) + "/" + birthDate.getDate())) {
    console.log('身份证上的出生日期非法')
    return false;
  }
  const currentDate = new Date();
  currentDate.setHours(23,59,59)
  birthDate.setHours(23,59,59)
  if(currentDate.getTime()-birthDate.getTime()<0){
    console.log('身份证上的出生日期非法,出生日期大于当前日期')
    return false;
  }
  let time = currentDate.getFullYear() - birthDate.getFullYear();
  if (time <0 || time > 150) {
    console.log('出生日期岁数不合理')
    return false;
  }

  // 身份证号码校验
  let sum = 0;
  for (let i = 0; i < checkCode.length - 1; i++) {
    sum += Number.parseInt(checkCode[i]) * weights[i];
  }
  const  lastCode = checkCodes[sum % 11]; //计算出来的最后一位身份证号码
  if (checkCode[checkCode.length - 1] != lastCode) {
    console.log('你输入的身份证号非法')
    return false
  }
  return true;
}

