export class LogUtils {
  private readonly enableDebug;

  constructor(debug) {
    this.enableDebug = debug
  }

  getTag(tag: string): string {
    return tag + '===================='
  }

  debug(msg: any): void {
    if (this.enableDebug) {
      console.debug(msg)
    }
  }

  debugWithTag(tag: string, msg: any): void {
    if (this.enableDebug) {
      console.debug(this.getTag(tag), msg)
    }
  }

  info(msg: any): void {
    if (this.enableDebug) {
      console.info(msg)
    }
  }

  infoWithTag(tag: string, msg: any): void {
    if (this.enableDebug) {
      console.info(this.getTag(tag), msg)
    }
  }

  log(msg: any): void {
    if (this.enableDebug) {
      console.log(msg)
    }
  }

  logWithTag(tag: string, msg: any): void {
    if (this.enableDebug) {
      console.log(this.getTag(tag), msg)
    }
  }

  error(msg: any): void {
    if (this.enableDebug) {
      console.error(msg)
    }
  }

  errorWithTag(tag: string, msg: any): void {
    if (this.enableDebug) {
      console.error(this.getTag(tag), msg)
    }
  }

  warn(msg: any): void {
    if (this.enableDebug) {
      console.warn(msg)
    }
  }

  warnWithTag(tag: string, msg: any): void {
    if (this.enableDebug) {
      console.warn(this.getTag(tag), msg)
    }
  }

}
