export class UrlHelper {
	/**
	 * 从地址中截取参数
	 * @param url
	 * @returns {Map<any, any>}
	 */
	static getQueryMapFromUrl(url: string): Map<string, any> {
		const map = new Map()
		if (url && url.indexOf("?") > 0) {
			let paramsStr = url.substring(url.indexOf("?") + 1)
			let groupList = paramsStr.split("&");
			if (groupList && groupList.length > 0) {
				groupList.forEach(item => {
					let strings = item.split("=");
					if (strings && strings.length > 1) {
						map.set(strings[0], strings[1])
					}
				})
			}
		}
		return map;
	}

	/**
	 * 获取跳转目标路径
	 * @param baseUrl
	 * @param params
	 * @returns {*}
	 */
	static getQueryUrl(baseUrl: string, params: object): string {
		let hasStartFlag = baseUrl.indexOf('?') !== -1
		if (params !== undefined && params instanceof Object) {
			let requestUtl = baseUrl
			for (let key in params) {
				if (params[key] !== undefined) {
					if (requestUtl.endsWith("?")) {
						requestUtl = `${requestUtl}${key}=${params[key]}`
					} else {
						requestUtl = `${requestUtl}${!hasStartFlag ? '?' : '&'}${key}=${params[key]}`
						if (!hasStartFlag) {
							hasStartFlag = true
						}
					}
				}
			}
			return requestUtl
		} else {
			return baseUrl
		}
	}
}
