import {InterceptorsConfig} from "./InterceptorsConfig";
import HttpClient from "./HttpClient";
const clientMap = new Map<string, HttpClient>();
type ClientInterceptors=()=>InterceptorsConfig;
export class HttpRequest {
	/**
	 * 获取求实例
	 * @param platform 平台
	 * @param isMiniApp 是不是小程序
	 * @param baseUrl 地址
	 * @param interceptors 拦截器信息
	 */
	static getHttpClient(platform: any,isMiniApp:boolean,baseUrl: string,interceptors?:ClientInterceptors): HttpClient {
		if (clientMap.has(baseUrl)) {
			const httpClient = clientMap.get(baseUrl);
			if (httpClient !== undefined) {
				return httpClient;
			}
		}
		let config = interceptors();
		let httpClient = new HttpClient(platform, isMiniApp, baseUrl,config?config:{});
		clientMap.set(baseUrl, httpClient)
		return httpClient;
	}
}
