import {ResponseInterceptor} from './ResponseInterceptor'
/**
 * 拦截器配置信息
 */
export interface InterceptorsConfig {
	/**
	 * 接口请求拦截器
	 * @param header
	 */
	onRequestInterceptor?: (header: object) => object;
	/**
	 * 接口响应拦截器
	 * @param response
	 */
	onResponseInterceptor?: (response: any) => ResponseInterceptor;

	/**
	 * 获取缓存数据
	 * @param baseUrl
	 * @param url
	 * @param params
	 */
	getCacheData?:(baseUrl: string, url: string, params?: any)=> any;

	/**
	 * 更新响应数据缓存
	 * @param data
	 * @param baseUrl
	 * @param url
	 * @param params
	 */
	updateResponseCache?:(data: any,baseUrl: string, url: string,params?: any)=> void;
	/**
	 * 获取缓存的Key
	 * @param baseUrl
	 * @param url
	 * @param data
	 * @param params
	 */
	getCacheKey?:(baseUrl: string, url: string, data: any, params?: any)=> string;
}
